<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2007-2009 Fillip Hannisdal AKA Revan/NeoRevan/Belazor # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
// vBSignatures functionality class

/**
* Handles everything to do with vBSignatures.
*
* @package	vBSignatures
* @version	$ $Rev$ $
* @date		$ $Date$ $
*/
class VBSIGNATURES_IMAGE
{
	
	/**
	* The final avatar image
	*
	* @public	resource
	*/		
	public static $final			= NULL;
	
	/**
	* The canvas
	*
	* @public	resource
	*/		
	private static $canvas			= NULL;
	
	/**
	* The layers we are requesting to add
	*
	* @public	array
	*/		
	private static $layers			= array();
	
	/**
	* The text regions we are requesting to add
	*
	* @public	array
	*/		
	private static $regions			= array();
	
	/**
	* The dimensions we are working with
	*
	* @public	array
	*/		
	private static $dimensions		= array();
	
	
	/**
	* Does important checking before anything else should be going on
	*
	* @param	vB_Registry	Registry object
	*/
	public static function init()
	{
		global $vbulletin;
		
		// Set dimensions
		self::$dimensions = array(
			'x' => $vbulletin->options['dbtech_vbsignatures_dimensions_x'],
			'y' => $vbulletin->options['dbtech_vbsignatures_dimensions_y']
		);
		
		// Initialise the canvas and set it to the correct size
		self::$canvas = imagecreatetruecolor(self::$dimensions['x'], self::$dimensions['y']);
		
		// Initialise the final image and set it to the correct size
		self::$final = imagecreatetruecolor(self::$dimensions['x'], self::$dimensions['y']);
		
		// lets get some colors for our canvas
		$black       = imagecolorallocate(self::$canvas, 0, 0, 0);
		$white       = imagecolorallocate(self::$canvas, 255, 255, 255);
		$red         = imagecolorallocate(self::$canvas, 255, 0, 0);
		$transparent = imagecolortransparent(self::$canvas);
		
		// Fill the canvas with glorious transparency
		imagefill(self::$canvas, 0, 0, $transparent);
		
		// I have no idea what this does if I'm honest, but I found it on PHP.Net and it works. Go away.
		imagecolortransparent(self::$final, imagecolorallocatealpha(self::$final, 0, 0, 0, 127));
		imagealphablending(self::$final, false);
		imagesavealpha(self::$final, true);		
	}
	
	/**
	* Adding an image to a specified layer
	*
	* @param	string	What layer this image is for
	* @param	mixed	The image, either a resource or a file path
	*/
	public static function addLayer($layer, $image)
	{
		if (!is_resource($image))
		{
			// The image was not a resource
			if (file_exists($image))
			{
				// It was, however, a file
				$image = imagecreatefrompng($image);
			}
			else
			{
				// This is 100% unusable
				return false;
			}
		}
		
		// Add this to the correct layer
		self::$layers[$layer] = $image;
	}
	
	/**
	* Adding a text region
	*
	* @param	array	Region information
	*/
	public static function addRegion($region)
	{
		// Grab the RGB value
		$region['rgb'] = VBSIGNATURES::html2rgb($region['fontcolor']);
		
		// Set default string if none exists
		$region['regiontext'] = ($region['regiontext'] ? $region['regiontext'] : 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin convallis hendrerit dui, et porttitor enim.');
		
		// Add this to the correct layer
		self::$regions[] = $region;
	}
	
	/**
	* Flattens the image and creates the final output image
	*/
	public static function flatten()
	{
		$layers = array();
		foreach ((array)VBSIGNATURES::$cache['layer'] as $layer)
		{
			// Store the layer entry
			$layers[] = ($layer['folder'] ? $layer['folder'] : 'base');
		}
		$layers[] = 'preview';
		
		foreach ($layers as $layer)
		{
			if (!is_resource(self::$layers[$layer]))
			{
				// Not a valid resource
				continue;
			}
			
			// Copy this layer to the canvas
			imagecopyresampled(
				self::$canvas, self::$layers[$layer], 
				0, 0, 0, 0, 
				self::$dimensions['x'], self::$dimensions['y'],
				self::$dimensions['x'], self::$dimensions['y']
			);
			
			// Destroy the remnant of the layer to save resources
			imagedestroy(self::$layers[$layer]);			
		}
		
		// Copy the canvas content to the final avatar image
		imagecopyresampled(
			self::$final, self::$canvas,
			0, 0, 0, 0,
			self::$dimensions['x'], self::$dimensions['y'],
			self::$dimensions['x'], self::$dimensions['y']
		);
		
		// Destroy the canvas to free resources
		imagedestroy(self::$canvas);
		
		foreach (self::$regions as $region)
		{
			if (!$region['xcoord'] OR !$region['ycoord'])
			{
				// Invalid region
				continue;
			}
			
			// Add the text region to the image
			if (VBSIGNATURES::$useTtf)
			{
				// Choose the correct font for the job
				$font = @realpath(DIR . '/' . VBSIGNATURES::$cache['font'][$region['fontid']]['fontfile_' . (int)$region['fontweight']] . '.ttf');
				$font = (file_exists($font) ? $font : realpath(DIR . '/dbtech/vbsignatures/fonts/default_0.ttf'));
				
				imagecolortransparent(
					self::$final,
					imagecolorallocate(
						self::$final,
						$region['rgb'][0],
						$region['rgb'][1],
						$region['rgb'][2]
					)					
				);
				imagealphablending(self::$final, true);
				imagettftext(
					self::$final,
					$region['fontsize'],
					0,
					$region['xcoord'],
					$region['ycoord'],
					imagecolorallocate(
						self::$final,
						$region['rgb'][0],
						$region['rgb'][1],
						$region['rgb'][2]
					),
					$font,
					substr($region['regiontext'], 0, $region['stringlength'])				
				);
			}
			else
			{			
				imagestring(
					self::$final,
					$region['fontsize'],
					$region['xcoord'],
					$region['ycoord'],
					substr($region['regiontext'], 0, $region['stringlength']),
					imagecolorallocate(
						self::$final,
						$region['rgb'][0],
						$region['rgb'][1],
						$region['rgb'][2]
					)
				);
			}
		}		
		
		// Prep the final resource
		return self::$final;
	}
}

/*======================================================================*\
|| ####################################################################
|| # Created: 16:52, Sat Dec 26th 2009
|| # SVN: $ $Rev$ $ - $ $Date$ $
|| ####################################################################
\*======================================================================*/